% Mikoaj Czajkowski , Wiktor Budziski 
% "Simulation error in maximum likelihood estimation of discrete choice
% models"
%
% Online materials
% 2019-03-08 

% Script calculates regressions presented in Table 3 and comparison of performace of different types of draws in Table 4

% "Table 3. Variation of the simulation results (log(MTL)) explained using
% characteristics of experimental settings"
% Table 4. The relative increase in the number of draws required to achieve the same simulation error as when using Sobol draws (95% confidence intervals in [] brackets)"

% INPUT: Code uses Output matrix from 'MTL_results05.mat' which can be generated with MTLcalc.m code

% OUTPUT: Code generates excel spreadsheet with Table 3 and Table 4

rng(10000001);
clear
clc

%% Reading data and setting matrices
load('MTL_results05.mat')

Names = {'Cons.'; 'Type of draws: Pseudo random (*5 Att)'; 'Type of draws: MLHS (*5 Att)'; 'Type of draws: Halton (*5 Att)'; 'Design is: MNL'; 'Design is: OOD'; 'No. of CT'; 'No. of individuals'; 'Log of No. of draws (*5 Att)';...
    'No. of attributes = 10'; 'Log of No. of draws (*10 Att)'; 'Type of draws: Pseudo random (*10 Att)'; 'Type of draws: MLHS (*10 Att)'; 'Type of draws: Halton (*10 Att)';...
    'Parameter for std';'SQ';'Cost'; 'R2'; 'N'};

Table_out = cell(length(Names)+1,4); % Table with results
Table_out(2:end,1) = Names;
Table_out(1,:) = {' ', 'LL', 'Betas','Z stats'}; 

% Explanatory variables for regression
XX = [(Output(:,42) == 1).*(Output(:,47) == 5), (Output(:,42) == 2).*(Output(:,47) == 5),(Output(:,42) == 3).*(Output(:,47) == 5), Output(:,43) == 1,Output(:,43) == 3, Output(:,45), Output(:,46), log(Output(:,44)).*(Output(:,47) == 5), ...
    Output(:,47) == 10, log(Output(:,44)).*(Output(:,47) == 10), (Output(:,42) == 1).*(Output(:,47) == 10), (Output(:,42) == 2).*(Output(:,47) == 10) ,(Output(:,42) == 3).*(Output(:,47) == 10)];

WTP = cell(4,4);
WTP(2:4, 1) = {'Pseudo Monte Carlo'; 'MLHS' ; 'Halton'};
WTP(1,:) ={' ', 'LL', 'Betas','Z stats'};

% for 10 attributes
WTP_10 = cell(4,4);
WTP_10 (2:4, 1) = {'Pseudo Monte Carlo'; 'MLHS' ; 'Halton'};
WTP_10 (1,:) ={' ', 'LL', 'Betas','Z stats'};

%% Regression for LL

% For Table 3
Y = Output(:,1);
X = XX;
X = X(~isnan(Y),:);
Y = Y(~isnan(Y),:);

% To store results:
T = zeros(size(X,2)+1,2);
P = zeros(size(X,2)+1,1);

res=fitlm(X, log(Y));
R2 = res.Rsquared.Ordinary;
stdx = sqrt(diag(res.CoefficientCovariance));
COV1 = res.CoefficientCovariance;
VarX =var(table2array(res.Residuals(:,1))); % Variance of residuals
T(:,1) =table2array(res.Coefficients(:,1));
Tplot = T(:,1);
T(:, 2) =stdx;
T(8,:) =  T(8,:)*1000;
pval = pv(T(:,1, 1), stdx);
P(:, 1) =pval;

% Saving results
for j =1:(size(X,2)+1)
    if P(j,1) <= 0.01
        Table_out(j+1,2) = {[num2str(T(j,1,1), '%8.4f'), '***     ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.05 &&  P(j,1) > 0.01
        Table_out(j+1,2) = {[num2str(T(j,1,1), '%8.4f'), '**      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.1 &&  P(j,1) > 0.05
        Table_out(j+1,2) = {[num2str(T(j,1,1), '%8.4f'), '*      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) > 0.1
        Table_out(j+1,2) = {[num2str(T(j,1,1), '%8.4f'), '       ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    end
end

Table_out(size(Table_out,1)-1,2) = {num2str(R2, '%1.4f')};
Table_out(size(Table_out,1),2) = {num2str(size(Y,1), '%8.4f')};

% For Table 4
SimX = mvnrnd(T(:,1)', res.CoefficientCovariance, 10000);

for i = 1:3
   TmpVec = exp(-SimX(:,1+i)./SimX(:,9))-1;
   WTP(i+1,2) =  {[num2str(100*(exp(-T(1+i,1)./T(9,1))-1), '%8.2f'), '%        ', '[', num2str(100*prctile(TmpVec, 2.5), '%8.2f'), '%-',num2str(100*prctile(TmpVec, 97.5), '%8.2f'), '%]']};
   TmpVec = exp(-SimX(:,11+i)./SimX(:,11))-1;
   WTP_10(i+1,2) =  {[num2str(100*(exp(-T(11+i,1)./T(11,1))-1), '%8.2f'), '%        ', '[', num2str(100*prctile(TmpVec, 2.5), '%8.2f'), '%-',num2str(100*prctile(TmpVec, 97.5), '%8.2f'), '%]']};
end


%% Regression for Beta


Y = reshape(Output(:,2:21), [size(Output,1)*20,1]);
X = XX;
X = repmat(X, [20,1]);

% Additional variables for the regression
att_10 = 9; % On which place is the variable for 10 att
Tmp2 = size(Output,1);
StdX = zeros(Tmp2,20);
StdX(XX(:,att_10) == 0,6:10) = 1;
StdX(XX(:,att_10) == 1,11:20) = 1;
StdX = reshape(StdX, [Tmp2*20,1]);
SQ = zeros(Tmp2,20);
SQ(XX(:,att_10) == 0,[1 6]) = 1;
SQ(XX(:,att_10) == 1,[1 11]) = 1;
SQ = reshape(SQ, [Tmp2*20,1]);
Cost = zeros(Tmp2,20);
Cost(XX(:,att_10) == 0,[5 10]) = 1;
Cost(XX(:,att_10) == 1,[10 20]) = 1;
Cost = reshape(Cost, [Tmp2*20,1]);

X = [X, [StdX, SQ, Cost]];
X = X(~isnan(Y),:);
Y = Y(~isnan(Y),:);

T = zeros(size(X,2)+1,2);
P = zeros(size(X,2)+1,1);

res=fitlm(X, log(Y));

R2 = res.Rsquared.Ordinary;
stdx = sqrt(diag(res.CoefficientCovariance));
VarX =var(table2array(res.Residuals(:,1)));

COV2 = res.CoefficientCovariance;
T(:,1) =table2array(res.Coefficients(:,1));
T(:, 2) =stdx;
T(8,:) =  T(8,:)*1000;
pval = pv(T(:,1, 1), stdx);
P(:, 1) =pval;


for j =1:(size(X,2)+1)
    if P(j,1) <= 0.01
        Table_out(j+1,3) = {[num2str(T(j,1,1), '%8.4f'), '***     ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.05 &&  P(j,1) > 0.01
        Table_out(j+1,3) = {[num2str(T(j,1,1), '%8.4f'), '**      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.1 &&  P(j,1) > 0.05
        Table_out(j+1,3) = {[num2str(T(j,1,1), '%8.4f'), '*      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) > 0.1
        Table_out(j+1,3) = {[num2str(T(j,1,1), '%8.4f'), '       ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
 
    end
end
Table_out(size(Table_out,1)-1,3) = {num2str(R2, '%1.4f')};
Table_out(size(Table_out,1),3) = {num2str(size(Y,1), '%8.4f')};

% For Table 4
SimX = mvnrnd(T(:,1)', res.CoefficientCovariance, 10000);
for i = 1:3
   TmpVec = exp(-SimX(:,1+i)./SimX(:,9))-1;
   WTP(i+1,3) =  {[num2str(100*(exp(-T(1+i,1)./T(9,1))-1), '%8.2f'), '%        ', '[', num2str(100*prctile(TmpVec, 2.5), '%8.2f'), '%-',num2str(100*prctile(TmpVec, 97.5), '%8.2f'), '%]']};
   TmpVec = exp(-SimX(:,11+i)./SimX(:,11))-1;
   WTP_10(i+1,3) =  {[num2str(100*(exp(-T(11+i,1)./T(11,1))-1), '%8.2f'), '%        ', '[', num2str(100*prctile(TmpVec, 2.5), '%8.2f'), '%-',num2str(100*prctile(TmpVec, 97.5), '%8.2f'), '%]']};
end

%% Regression for Z-stats

Y = reshape(Output(:,22:41), [size(Output,1)*20,1]);
X = XX;
X = repmat(X, [20,1]);

StdX = zeros(Tmp2,20);
StdX(XX(:,att_10) == 0,6:10) = 1;
StdX(XX(:,att_10) == 1,11:20) = 1;
StdX = reshape(StdX, [Tmp2*20,1]);
SQ = zeros(Tmp2,20);
SQ(XX(:,att_10) == 0,[1 6]) = 1;
SQ(XX(:,att_10) == 1,[1 11]) = 1;
SQ = reshape(SQ, [Tmp2*20,1]);
Cost = zeros(Tmp2,20);
Cost(XX(:,att_10) == 0,[5 10]) = 1;
Cost(XX(:,att_10) == 1,[10 20]) = 1;
Cost = reshape(Cost, [Tmp2*20,1]);

X = [X, [StdX, SQ, Cost]];
X = X(~isnan(Y),:);
Y = Y(~isnan(Y),:);

T = zeros(size(X,2)+1,2);
P = zeros(size(X,2)+1,1);

res=fitlm(X, log(Y));

R2 = res.Rsquared.Ordinary;
stdx = sqrt(diag(res.CoefficientCovariance));
COV3 = res.CoefficientCovariance;
VarX =var(table2array(res.Residuals(:,1)));

T(:,1) =table2array(res.Coefficients(:,1));
T(:, 2) =stdx;
T(8,:) =  T(8,:)*1000;
pval = pv(T(:,1, 1), stdx);
P(:, 1) =pval;


for j =1:(size(X,2)+1)
    if P(j,1) <= 0.01
        Table_out(j+1,4) = {[num2str(T(j,1,1), '%8.4f'), '***     ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.05 &&  P(j,1) > 0.01
        Table_out(j+1,4) = {[num2str(T(j,1,1), '%8.4f'), '**      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) <= 0.1 &&  P(j,1) > 0.05
        Table_out(j+1,4) = {[num2str(T(j,1,1), '%8.4f'), '*      ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
    elseif  P(j,1) > 0.1
        Table_out(j+1,4) = {[num2str(T(j,1,1), '%8.4f'), '       ', '(', num2str(T(j,2,1), '%8.4f'), ')']};
 
    end
end
% For Table 4

SimX = mvnrnd(T(:,1)', res.CoefficientCovariance, 10000);
for i = 1:3
   TmpVec = exp(-SimX(:,1+i)./SimX(:,9))-1;
   WTP(i+1,4) =  {[num2str(100*(exp(-T(1+i,1)./T(9,1))-1), '%8.2f'), '%        ', '[', num2str(100*prctile(TmpVec, 2.5), '%8.2f'), '%-',num2str(100*prctile(TmpVec, 97.5), '%8.2f'), '%]']};
   TmpVec = exp(-SimX(:,11+i)./SimX(:,11))-1;
   WTP_10(i+1,4) =  {[num2str(100*(exp(-T(11+i,1)./T(11,1))-1), '%8.2f'), '%        ', '[', num2str(100*prctile(TmpVec, 2.5), '%8.2f'), '%-',num2str(100*prctile(TmpVec, 97.5), '%8.2f'), '%]']};
end


%% Saving results

cd('C:\Users\wbudzinski\Documents\Drawy\Codes') % Directory for saving excel file 
Table_out(size(Table_out,1)-1,4) = {num2str(R2, '%1.4f')};
Table_out(size(Table_out,1),4) = {num2str(size(Y,1), '%8.4f')};
Table_out = Table_out([1:2 11 3:5 13:15 10 12 8:9 7 6 16:20],:);
xlswrite('Results20190308.xls', Table_out, 'Table3', 'A1');
xlswrite('Results20190308.xls', WTP, 'Table4', 'A1');
xlswrite('Results20190308.xls', WTP_10, 'Table4', 'A7');